/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util.progress;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import oracle.install.commons.util.EventSupport;
import oracle.install.commons.util.exception.Severity;
import oracle.install.commons.util.progress.CompositeJobEvent;
import oracle.install.commons.util.progress.CompositeJobListener;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.Pausable;
import oracle.install.commons.util.progress.ProgressMonitor;
import oracle.install.commons.util.progress.Status;

public class CompositeJob
extends Job {
    private List<Job> jobList = new ArrayList<Job>();
    private ProgressMonitor progressMonitor;
    private EventSupport<CompositeJobEvent> eventSupport = new EventSupport();
    private static final PropertyChangeListener progressChangeListener = new ProgressChangeListener();
    private static final PropertyChangeListener statusChangeListener = new StatusChangeListener();
    private static final PropertyChangeListener failureSeverityChangeListener = new FailureSeverityChangeListener();
    private float progressMinLimit;

    public CompositeJob() {
        this(null, 1.0f);
    }

    public CompositeJob(Object id, float weightage) {
        this(id, null, weightage);
    }

    public CompositeJob(Object id, String description, float weightage) {
        super(id, description, weightage);
    }

    public void setProgressMonitor(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public List<Job> getJobs() {
        return this.jobList;
    }

    public void setJobs(Job ... jobs) {
        if (jobs != null) {
            this.removeAll();
            for (Job task : jobs) {
                task.setParent(this);
                this.add(task);
            }
        }
    }

    public void add(Job job) {
        this.add(job, false);
    }

    public void add(Job job, boolean reloadListeners) {
        if (job != null && this.jobList.add(job)) {
            if (reloadListeners) {
                job.removePropertyChangeListener("Job.progress", progressChangeListener);
                job.removePropertyChangeListener("Job.status", statusChangeListener);
                job.removePropertyChangeListener("Job.failureSeverity", failureSeverityChangeListener);
            }
            job.setParent(this);
            job.addPropertyChangeListener("Job.progress", progressChangeListener);
            job.addPropertyChangeListener("Job.status", statusChangeListener);
            job.addPropertyChangeListener("Job.failureSeverity", failureSeverityChangeListener);
            this.eventSupport.fireEvent(new CompositeJobEvent(this, CompositeJobEvent.Type.JOB_ADDED, job));
        }
    }

    public void remove(Job job) {
        if (this.jobList.remove(job)) {
            job.removePropertyChangeListener("Job.progress", progressChangeListener);
            job.removePropertyChangeListener("Job.status", statusChangeListener);
            job.removePropertyChangeListener("Job.failureSeverity", failureSeverityChangeListener);
            this.eventSupport.fireEvent(new CompositeJobEvent(this, CompositeJobEvent.Type.JOB_REMOVED, job));
        }
    }

    public void removeAll() {
        Iterator<Job> i = this.jobList.iterator();
        while (i.hasNext()) {
            Job task = i.next();
            i.remove();
            this.eventSupport.fireEvent(new CompositeJobEvent(this, CompositeJobEvent.Type.JOB_REMOVED, task));
            task.setParent(null);
        }
    }

    public void addCompositeJobListener(CompositeJobListener compositeJobListener) {
        this.eventSupport.addEventListener(compositeJobListener);
    }

    public void removeCompositeJobListener(CompositeJobListener compositeJobListener) {
        this.eventSupport.removeEventListener(compositeJobListener);
    }

    public void calibrate() {
        float totalWeigtage = 0.0f;
        for (Job job : this.jobList) {
            if (job.isCompleted()) continue;
            if (job instanceof CompositeJob) {
                ((CompositeJob)job).calibrate();
            }
            totalWeigtage += job.getWeightage();
        }
        if (totalWeigtage > 1.0f || totalWeigtage < 1.0f) {
            for (Job job : this.jobList) {
                if (job.isCompleted()) continue;
                job.setActualWeightage(job.getWeightage() / totalWeigtage);
            }
        }
    }

    public int getCompletedJobs() {
        int completedJobCount = 0;
        for (Job job : this.jobList) {
            if (!job.isCompleted()) continue;
            ++completedJobCount;
        }
        return completedJobCount;
    }

    @Override
    public void reset() {
        if (this.jobList != null) {
            for (Job job : this.jobList) {
                job.reset();
            }
        }
        this.progressMinLimit = 0.0f;
        super.reset();
    }

    @Override
    public void setPausable(Pausable pausable) {
        if (this.jobList != null) {
            for (Job job : this.jobList) {
                job.setPausable(pausable);
            }
        }
    }

    @Override
    public void release() {
        for (Job job : this.jobList) {
            job.release();
        }
        this.jobList.clear();
        this.jobList = null;
        this.eventSupport.release();
        this.eventSupport = null;
        this.progressMonitor = null;
        super.release();
    }

    static class FailureSeverityChangeListener
    implements PropertyChangeListener {
        static List<Severity> severityOrderList = Arrays.asList(Severity.TRIVIAL, Severity.WARNING, Severity.FATAL);

        FailureSeverityChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object source = evt.getSource();
            if (source instanceof Job) {
                Job task = (Job)source;
                CompositeJob parentJob = task.getParent();
                List<Job> jobs = parentJob.getJobs();
                Severity failureSeverity = null;
                int currentOrderIndex = -1;
                for (Job j : jobs) {
                    int orderIndex;
                    Severity childJobFailureSeverity = j.getFailureSeverity();
                    if (childJobFailureSeverity == null || (orderIndex = severityOrderList.indexOf((Object)childJobFailureSeverity)) <= currentOrderIndex) continue;
                    currentOrderIndex = orderIndex;
                }
                if (currentOrderIndex >= 0) {
                    failureSeverity = severityOrderList.get(currentOrderIndex);
                }
                parentJob.setFailureSeverity(failureSeverity);
            }
        }
    }

    static class ProgressChangeListener
    implements PropertyChangeListener {
        ProgressChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Job task;
            CompositeJob parent;
            Object source = evt.getSource();
            if (source instanceof Job && (parent = (task = (Job)source).getParent()) != null) {
                float progress = ((Float)evt.getNewValue()).floatValue();
                float weightage = task.getActualWeightage();
                float newProgress = parent.progressMinLimit + weightage * progress;
                if (progress >= 1.0f) {
                    newProgress = parent.progressMinLimit + weightage;
                    parent.progressMinLimit += weightage;
                }
                parent.setProgress(newProgress);
            }
        }
    }

    static class StatusChangeListener
    implements PropertyChangeListener {
        StatusChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object source = evt.getSource();
            if (source instanceof Job) {
                Job task = (Job)source;
                CompositeJob parentJob = task.getParent();
                Status status = task.getStatus();
                switch (status) {
                    case PENDING: 
                    case SUSPENDED: 
                    case INPROGRESS: {
                        parentJob.setStatus(status);
                        break;
                    }
                    case IGNORED: 
                    case CANCELLED: 
                    case FAILED: 
                    case WARNING: 
                    case SUCCEEDED: 
                    case SUCCEEDED_PARTIALLY: {
                        int completedJobCount = parentJob.getCompletedJobs();
                        if (completedJobCount != parentJob.getJobs().size()) break;
                        List<Job> jobs = parentJob.getJobs();
                        Status s = Status.SUCCEEDED;
                        for (Job j : jobs) {
                            Status childJobStatus = j.getStatus();
                            if (childJobStatus == Status.CANCELLED || childJobStatus == Status.FAILED) {
                                if (j.isRequired()) {
                                    s = childJobStatus;
                                    break;
                                }
                                s = Status.SUCCEEDED_PARTIALLY;
                                continue;
                            }
                            if (childJobStatus != Status.WARNING && childJobStatus != Status.SUCCEEDED_PARTIALLY) continue;
                            s = Status.SUCCEEDED_PARTIALLY;
                        }
                        parentJob.setStatus(s);
                    }
                }
            }
        }
    }
}

